using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

/*
   dotNETCube a game demonstrating dynamically created graphics objects.
   Example submitted by Endre I. Simay, Hungary
*/

namespace Project1 {

public class WinForm : System.Windows.Forms.Form {

		int complet = 1;
        int first = 40;
        int block = 40;
        int sp = 5;
        int steps = 0;

		private string [] colors = new string [4]{"Red","Blue","Green","Yellow"};

		private System.Windows.Forms.Panel pnlHost;
		private System.Windows.Forms.Label lblComplett;
		private System.Windows.Forms.Panel pnlSteps;
		private System.Windows.Forms.Label lblStep1;
		private System.Windows.Forms.Label lblStep2;
		private System.Windows.Forms.Button btnShuffle;

		private System.Windows.Forms.Panel [,] pnlCubs = new System.Windows.Forms.Panel [4,4];
        private System.Windows.Forms.Button [] btnUp = new System.Windows.Forms.Button [4];
        private System.Windows.Forms.Button [] btnDown = new System.Windows.Forms.Button [4];
        private System.Windows.Forms.Button [] btnLeft = new System.Windows.Forms.Button [4];
        private System.Windows.Forms.Button [] btnRight = new System.Windows.Forms.Button [4];


        public WinForm() {
            this.InitializeComponent();
        }

        public static void Main() {
            System.Windows.Forms.Application.Run(new WinForm());
        }

        private void InitializeComponent()
		{
			this.pnlHost = new System.Windows.Forms.Panel();
			this.pnlSteps = new System.Windows.Forms.Panel();
			this.lblStep2 = new System.Windows.Forms.Label();
			this.lblStep1 = new System.Windows.Forms.Label();
			this.btnShuffle = new System.Windows.Forms.Button();
			this.lblComplett = new System.Windows.Forms.Label();
			this.pnlSteps.SuspendLayout();
			this.SuspendLayout();
			// 
			// pnlHost
			// 
			this.pnlHost.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.pnlHost.Location = new System.Drawing.Point(16, 16);
			this.pnlHost.Name = "pnlHost";
			this.pnlHost.Size = new System.Drawing.Size(272, 240);
			this.pnlHost.TabIndex = 0;
			// 
			// pnlSteps
			// 
			this.pnlSteps.Controls.Add(this.lblStep2);
			this.pnlSteps.Controls.Add(this.lblStep1);
			this.pnlSteps.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.pnlSteps.Location = new System.Drawing.Point(16, 280);
			this.pnlSteps.Name = "pnlSteps";
			this.pnlSteps.Size = new System.Drawing.Size(272, 40);
			this.pnlSteps.TabIndex = 1;
			// 
			// lblStep2
			// 
			this.lblStep2.Location = new System.Drawing.Point(168, 8);
			this.lblStep2.Name = "lblStep2";
			this.lblStep2.Size = new System.Drawing.Size(88, 16);
			this.lblStep2.TabIndex = 1;
			this.lblStep2.Text = "label2";
			// 
			// lblStep1
			// 
			this.lblStep1.AutoSize = true;
			this.lblStep1.Location = new System.Drawing.Point(8, 8);
			this.lblStep1.Name = "lblStep1";
			this.lblStep1.Size = new System.Drawing.Size(94, 16);
			this.lblStep1.TabIndex = 0;
			this.lblStep1.Text = "Number of steps:";
			// 
			// btnShuffle
			// 
			this.btnShuffle.Location = new System.Drawing.Point(304, 16);
			this.btnShuffle.Name = "btnShuffle";
			this.btnShuffle.Size = new System.Drawing.Size(72, 24);
			this.btnShuffle.TabIndex = 2;
			this.btnShuffle.Text = "Shuffle";
			this.btnShuffle.Click += new System.EventHandler(this.btnShuffle_Click);
			// 
			// lblComplett
			// 
			this.lblComplett.Font = new System.Drawing.Font("Microsoft Sans Serif", 24F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(238)));
			this.lblComplett.ForeColor = System.Drawing.SystemColors.InactiveCaption;
			this.lblComplett.Location = new System.Drawing.Point(16, 336);
			this.lblComplett.Name = "lblComplett";
			this.lblComplett.Size = new System.Drawing.Size(304, 40);
			this.lblComplett.TabIndex = 3;
			this.lblComplett.Text = "Congratulations!!!";
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.Color.LightGray;
			this.ClientSize = new System.Drawing.Size(397, 401);
			this.Controls.Add(this.lblComplett);
			this.Controls.Add(this.btnShuffle);
			this.Controls.Add(this.pnlSteps);
			this.Controls.Add(this.pnlHost);
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(405, 435);
			this.MinimumSize = new System.Drawing.Size(405, 435);
			this.Name = "WinForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "dotNetCube";
			this.Load += new System.EventHandler(this.WinForm_Load);
			this.pnlSteps.ResumeLayout(false);
			this.ResumeLayout(false);
		}

		private void SetupForm () {
			this.pnlHost.Size = new System.Drawing.Size(2*first+4*block+3*sp, 2*first+4*block+3*sp);
			this.btnShuffle.Top = this.pnlHost.Top;

			for (int i = 0; i < 4; i++) {

				btnUp[i] = new System.Windows.Forms.Button();
				btnDown[i] = new System.Windows.Forms.Button();
				btnLeft[i] = new System.Windows.Forms.Button();
				btnRight[i] = new System.Windows.Forms.Button();

				this.btnUp[i].Location = new System.Drawing.Point(first+i*block+i*sp,first-25);
				this.btnUp[i].Size = new System.Drawing.Size(block, 20);
				this.btnUp[i].BackColor = System.Drawing.Color.Silver;

				this.btnDown[i].Location = new System.Drawing.Point(first+i*block+i*sp,first+3*block+3*sp+block+5);
				this.btnDown[i].Size = new System.Drawing.Size(block, 20);
				this.btnDown[i].BackColor = System.Drawing.Color.Silver;

				this.btnLeft[i].Location = new System.Drawing.Point(first-25,first+i*block+i*sp);
				this.btnLeft[i].Size = new System.Drawing.Size(20,block);
				this.btnLeft[i].BackColor = System.Drawing.Color.Silver;

				this.btnRight[i].Location = new System.Drawing.Point(first+3*block+3*sp+block+5,first+i*block+i*sp);
				this.btnRight[i].Size = new System.Drawing.Size(20,block);
				this.btnRight[i].BackColor = System.Drawing.Color.Silver;

				this.pnlHost.Controls.AddRange(new System.Windows.Forms.Control[] {
				   this.btnUp[i],this.btnDown[i],this.btnLeft[i],this.btnRight[i] });

			}
			this.btnUp[0].Click += new System.EventHandler(this.btnUp1_Click);
			this.btnUp[1].Click += new System.EventHandler(this.btnUp2_Click);
			this.btnUp[2].Click += new System.EventHandler(this.btnUp3_Click);
			this.btnUp[3].Click += new System.EventHandler(this.btnUp4_Click);

			this.btnDown[0].Click += new System.EventHandler(this.btnDown1_Click);
			this.btnDown[1].Click += new System.EventHandler(this.btnDown2_Click);
			this.btnDown[2].Click += new System.EventHandler(this.btnDown3_Click);
			this.btnDown[3].Click += new System.EventHandler(this.btnDown4_Click);

			this.btnLeft[0].Click += new System.EventHandler(this.btnLeft1_Click);
			this.btnLeft[1].Click += new System.EventHandler(this.btnLeft2_Click);
			this.btnLeft[2].Click += new System.EventHandler(this.btnLeft3_Click);
			this.btnLeft[3].Click += new System.EventHandler(this.btnLeft4_Click);

			this.btnRight[0].Click += new System.EventHandler(this.btnRight1_Click);
			this.btnRight[1].Click += new System.EventHandler(this.btnRight2_Click);
			this.btnRight[2].Click += new System.EventHandler(this.btnRight3_Click);
			this.btnRight[3].Click += new System.EventHandler(this.btnRight4_Click);


			for (int i = 0; i < 4; i++) {
				for (int j = 0; j < 4; j++) {
					pnlCubs[j,i] = new System.Windows.Forms.Panel();
					pnlCubs[j,i].Size =  new System.Drawing.Size(block, block);
                    pnlCubs[j,i].BackColor = System.Drawing.Color.FromName(colors[i]);
                    pnlCubs[j,i].Location = new System.Drawing.Point(first+(j)*block+(j)*sp,
                                            first+(i)*block+(i)*sp );
                    this.pnlHost.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                       this.pnlCubs [j,i] });
                }
            }

            pnlSteps.Top = pnlHost.Bottom + 20;
            pnlSteps.Width = pnlHost.Width;
			pnlSteps.Height = lblStep1.Height;
			lblStep1.Top = 0;
			lblStep1.Left = 0;
			lblStep2.Top = 0;
			lblStep2.Height = lblStep1.Height;
			lblStep2.Left = lblStep1.Right+10;
			lblStep2.Text = steps.ToString();
			btnShuffle.Enabled = (complet == 1);
			lblComplett.Left = pnlHost.Left;
			lblComplett.ForeColor = System.Drawing.Color.FromName("Blue");
			lblComplett.Visible = false;
		}

		private int IfComplet () {
			int tried = 0;
			if (
				(
					(pnlCubs[0,1].BackColor == System.Drawing.Color.FromName(colors[1]))
					&&
					(pnlCubs[1,1].BackColor ==pnlCubs[0,1].BackColor)
					&&
					(pnlCubs[2,1].BackColor ==pnlCubs[0,1].BackColor)
					&&
					(pnlCubs[3,1].BackColor ==pnlCubs[0,1].BackColor)
				)
				&&
				(
					(pnlCubs[0,2].BackColor == System.Drawing.Color.FromName(colors[2]))
					&&
					(pnlCubs[1,2].BackColor ==pnlCubs[0,2].BackColor)
					&&
					(pnlCubs[2,2].BackColor ==pnlCubs[0,2].BackColor)
					&&
					(pnlCubs[3,2].BackColor ==pnlCubs[0,2].BackColor)
				)
				&&
				(
					(pnlCubs[0,3].BackColor == System.Drawing.Color.FromName(colors[3]))
					&&
					(pnlCubs[1,3].BackColor ==pnlCubs[0,3].BackColor)
					&&
					(pnlCubs[2,3].BackColor ==pnlCubs[0,3].BackColor)
					&&
					(pnlCubs[3,3].BackColor ==pnlCubs[0,3].BackColor)
				)
				&&
				(
					(pnlCubs[0,0].BackColor == System.Drawing.Color.FromName(colors[0]))
					&&
					(pnlCubs[1,0].BackColor ==pnlCubs[0,0].BackColor)
					&&
					(pnlCubs[2,0].BackColor ==pnlCubs[0,0].BackColor)
					&&
					(pnlCubs[3,0].BackColor ==pnlCubs[0,0].BackColor)
				)
			)
			{
				tried = 1;
			}

			return tried;
		}

		private void ColUp (int i) {
			if ( complet != 1 ) {
				System.Drawing.Color tempcol = pnlCubs[i,0].BackColor;
				pnlCubs[i,0].BackColor = pnlCubs[i,1].BackColor;
				pnlCubs[i,1].BackColor = pnlCubs[i,2].BackColor;
				pnlCubs[i,2].BackColor = pnlCubs[i,3].BackColor;
				pnlCubs[i,3].BackColor = tempcol;
				steps++;
			}
		}
		private void ColDown (int i) {
			if ( complet != 1 ) {
				System.Drawing.Color tempcol = pnlCubs[i,3].BackColor;
				pnlCubs[i,3].BackColor = pnlCubs[i,2].BackColor;
				pnlCubs[i,2].BackColor = pnlCubs[i,1].BackColor;
                pnlCubs[i,1].BackColor = pnlCubs[i,0].BackColor;
                pnlCubs[i,0].BackColor = tempcol;
                steps++;
            }
        }

        private void RowLeft (int i) {
            if ( complet != 1 ) {
                System.Drawing.Color tempcol = pnlCubs[0,i].BackColor;
                pnlCubs[0,i].BackColor = pnlCubs[1,i].BackColor;
                pnlCubs[1,i].BackColor = pnlCubs[2,i].BackColor;
                pnlCubs[2,i].BackColor = pnlCubs[3,i].BackColor;
                pnlCubs[3,i].BackColor = tempcol;
                steps++;
            }
        }

        private void RowRight (int i) {
            if ( complet != 1 ) {
				System.Drawing.Color tempcol = pnlCubs[3,i].BackColor;
				pnlCubs[3,i].BackColor = pnlCubs[2,i].BackColor;
                pnlCubs[2,i].BackColor = pnlCubs[1,i].BackColor;
                pnlCubs[1,i].BackColor = pnlCubs[0,i].BackColor;
                pnlCubs[0,i].BackColor = tempcol;
                steps++;
            }
        }

        private void CompParams() {
            this.lblStep2.Text=steps.ToString();
            complet = IfComplet();
            btnShuffle.Enabled = (complet == 1);
            lblComplett.Visible = (complet == 1);
        }

        private void btnUp1_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.ColUp(0);
                CompParams();
            }
        }
        private void btnUp2_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
				this.ColUp(1);
				CompParams();
            }
        }
		private void btnUp3_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.ColUp(2);
                CompParams();
            }
        }
        private void btnUp4_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.ColUp(3);
                CompParams();
            }
        }

        private void btnDown1_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.ColDown(0);
                CompParams();
            }
        }

		private void btnDown2_Click(object sender, System.EventArgs e) {
			if (complet !=1) {
                this.ColDown(1);
                CompParams();
			}
        }

        private void btnDown3_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.ColDown(2);
                CompParams();
            }
        }

        private void btnDown4_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.ColDown(3);
                CompParams();
            }
        }

        private void btnLeft1_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.RowLeft(0);
				CompParams();
			}
        }
        private void btnLeft2_Click(object sender, System.EventArgs e) {
			if (complet !=1) {
                this.RowLeft(1);
                CompParams();
            }
        }
        private void btnLeft3_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.RowLeft(2);
                CompParams();
            }
        }
        private void btnLeft4_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.RowLeft(3);
                CompParams();
            }
        }

        private void btnRight1_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
				this.RowRight(0);
				CompParams();
            }
        }
		private void btnRight2_Click(object sender, System.EventArgs e) {
            if (complet !=1) {
                this.RowRight(1);
                CompParams();
            }
        }
		private void btnRight3_Click(object sender, System.EventArgs e) {
			if (complet !=1) {
                this.RowRight(2);
				CompParams();
			}
		}
		private void btnRight4_Click(object sender, System.EventArgs e) {
			if (complet !=1) {
				this.RowRight(3);
				CompParams();
			}
		}
		private void WinForm_Load(object sender, System.EventArgs e) {
			this.SetupForm();
		}

		private void btnShuffle_Click(object sender, System.EventArgs e) {

			int shuffleVoid;
			System.Random C = new System.Random();

			complet = 0;

			for (int i = 0; i < 20; i++) {
				shuffleVoid = C.Next(1,4);
				switch (shuffleVoid) {
				case 1: {
						ColUp (C.Next(1,4));
						break;
					}
				case 2: {
						ColDown (C.Next(1,4));
						break;
					}
				case 3: {
						RowLeft (C.Next(1,4));
						break;
					}
				case 4: {
						RowRight (C.Next(1,4));
						break;
					}
				}
			}
			steps = 0;
			btnShuffle.Enabled = (complet==1);
			lblComplett.Visible = (complet==1);
		}
	}
}

